import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.itemUseOn.subscribe(data => {
    const block = data.block
    const player = data.source
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    if (selectedItem?.hasTag('minecraft:is_axe') && (block.typeId.includes('minecraft:exposed') || block.typeId.includes('v360:exposed'))) {
        system.run(() => {
            block.dimension.spawnItem(new ItemStack('v360:copper_patina', 1), block.center())
        })
    }
    else if (selectedItem?.hasTag('minecraft:is_axe') && (block.typeId.includes('minecraft:weathered') || block.typeId.includes('v360:weathered'))) {
        system.run(() => {
            block.dimension.spawnItem(new ItemStack('v360:copper_patina', 2), block.center())
        })
    }
    else if (selectedItem?.hasTag('minecraft:is_axe') && (block.typeId.includes('minecraft:oxidized') || block.typeId.includes('v360:oxidized'))) {
        system.run(() => {
            block.dimension.spawnItem(new ItemStack('v360:copper_patina', 3), block.center())
        })
    }
})